<?php $__env->startSection('title', 'User Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header with Actions -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0"><?php echo e($user->full_name); ?></h1>
            <p class="text-muted"><?php echo e($user->email); ?></p>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
            <?php if(!$user->email_verified_at): ?>
            <form action="<?php echo e(route('users.verify', $user)); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to verify this user? This will update all related records.')">
                    <i class="fas fa-check-circle"></i> Verify User
                </button>
            </form>
            <?php endif; ?>
            <a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-primary">
                <i class="fas fa-edit"></i> Edit
            </a>
        </div>
    </div>

    <!-- User Information Card -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Avatar and Basic Info -->
                        <div class="col-md-4 text-center">
                            <div class="avatar-circle bg-primary text-white mx-auto mb-3" style="width: 80px; height: 80px; font-size: 32px; display: flex; align-items: center; justify-content: center;">
                                <?php echo e(strtoupper(substr($user->first_name, 0, 1))); ?>

                            </div>
                            <span class="badge badge-<?php echo e($user->role == 'admin' ? 'danger' : ($user->role == 'manager' ? 'warning' : 'success')); ?> mb-2">
                                <?php echo e(ucfirst($user->role)); ?>

                            </span>
                            <?php if($user->email_verified_at): ?>
                                <div><small class="text-success"><i class="fas fa-check-circle"></i> Verified</small></div>
                            <?php else: ?>
                                <div><small class="text-warning"><i class="fas fa-exclamation-triangle"></i> Unverified</small></div>
                            <?php endif; ?>
                        </div>

                        <!-- Details -->
                        <div class="col-md-8">
                            <dl class="row">
                                <dt class="col-sm-4">Full Name:</dt>
                                <dd class="col-sm-8"><?php echo e($user->full_name); ?></dd>

                                <dt class="col-sm-4">First Name:</dt>
                                <dd class="col-sm-8"><?php echo e($user->first_name); ?></dd>

                                <dt class="col-sm-4">Second Name:</dt>
                                <dd class="col-sm-8"><?php echo e($user->second_name); ?></dd>

                                <dt class="col-sm-4">ID Number:</dt>
                                <dd class="col-sm-8"><?php echo e($user->id_number); ?></dd>

                                <dt class="col-sm-4">Email:</dt>
                                <dd class="col-sm-8">
                                    <a href="mailto:<?php echo e($user->email); ?>"><?php echo e($user->email); ?></a>
                                </dd>

                                <dt class="col-sm-4">Phone:</dt>
                                <dd class="col-sm-8">
                                    <a href="tel:<?php echo e($user->phone_number); ?>"><?php echo e($user->phone_number); ?></a>
                                </dd>

                                <dt class="col-sm-4">Branch:</dt>
                                <dd class="col-sm-8">
                                    <?php if($user->branch): ?>
                                        <?php echo e($user->branch->name); ?>

                                    <?php else: ?>
                                        <span class="text-muted">Not assigned</span>
                                    <?php endif; ?>
                                </dd>

                                <dt class="col-sm-4">Member Since:</dt>
                                <dd class="col-sm-8"><?php echo e($user->created_at->format('M d, Y')); ?></dd>

                                <dt class="col-sm-4">Last Updated:</dt>
                                <dd class="col-sm-8"><?php echo e($user->updated_at->format('M d, Y')); ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats Sidebar -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title">Quick Stats</h6>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Role:</span>
                        <strong><?php echo e(ucfirst($user->role)); ?></strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Status:</span>
                        <span class="badge badge-<?php echo e($user->email_verified_at ? 'success' : 'warning'); ?>">
                            <?php echo e($user->email_verified_at ? 'Verified' : 'Unverified'); ?>

                        </span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Joined:</span>
                        <small><?php echo e($user->created_at->diffForHumans()); ?></small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\users\show.blade.php ENDPATH**/ ?>