<?php $__env->startSection('title', 'Edit Loan Application'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Edit Loan Application</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Loan Application #<?php echo e($loan->id); ?></h3>
                </div>

                <form action="<?php echo e(route('loans.update', $loan)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="user_id">Member <span class="text-danger">*</span></label>
                                    <select name="user_id" id="user_id" class="form-control <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                        <option value="">Select Member</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>" <?php echo e(old('user_id', $loan->user_id) == $user->id ? 'selected' : ''); ?>>
                                            <?php echo e($user->full_name); ?> (<?php echo e($user->id_number); ?>)
                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Loan Amount (KSh) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('amount', $loan->amount)); ?>" min="1000" step="0.01" required>
                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interest_rate">Interest Rate (%) <span class="text-danger">*</span></label>
                                    <input type="number" name="interest_rate" id="interest_rate" class="form-control <?php $__errorArgs = ['interest_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('interest_rate', $loan->interest_rate)); ?>" min="0" max="50" step="0.01" required>
                                    <?php $__errorArgs = ['interest_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">Status <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                        <option value="pending" <?php echo e(old('status', $loan->status) == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                        <option value="approved" <?php echo e(old('status', $loan->status) == 'approved' ? 'selected' : ''); ?>>Approved</option>
                                        <option value="rejected" <?php echo e(old('status', $loan->status) == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                                        <option value="active" <?php echo e(old('status', $loan->status) == 'active' ? 'selected' : ''); ?>>Active</option>
                                        <option value="paid" <?php echo e(old('status', $loan->status) == 'paid' ? 'selected' : ''); ?>>Paid</option>
                                        <option value="defaulted" <?php echo e(old('status', $loan->status) == 'defaulted' ? 'selected' : ''); ?>>Defaulted</option>
                                    </select>
                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="application_date">Application Date <span class="text-danger">*</span></label>
                                    <input type="date" name="application_date" id="application_date" class="form-control <?php $__errorArgs = ['application_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('application_date', $loan->application_date ? $loan->application_date->format('Y-m-d') : '')); ?>" required>
                                    <?php $__errorArgs = ['application_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_date">Return Date <span class="text-danger">*</span></label>
                                    <input type="date" name="return_date" id="return_date" class="form-control <?php $__errorArgs = ['return_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('return_date', $loan->return_date ? $loan->return_date->format('Y-m-d') : '')); ?>" required>
                                    <?php $__errorArgs = ['return_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">Notes</label>
                                    <textarea name="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                              rows="3" placeholder="Additional notes about the loan application"><?php echo e(old('notes', $loan->notes)); ?></textarea>
                                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Loan Calculator Preview -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-info">
                                    <div class="card-header">
                                        <h5 class="card-title">Loan Calculation Preview</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Principal Amount</span>
                                                        <span class="info-box-number" id="preview-principal">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Interest Amount</span>
                                                        <span class="info-box-number" id="preview-interest">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Total Amount</span>
                                                        <span class="info-box-number" id="preview-total">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Monthly Payment</span>
                                                        <span class="info-box-number" id="preview-monthly">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Loan Security/Guarantees Section -->
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card card-outline card-warning">
                                    <div class="card-header">
                                        <h5 class="card-title">
                                            <i class="fas fa-shield-alt mr-2"></i>Loan Security & Guarantees
                                        </h5>
                                        <div class="card-tools">
                                            <button type="button" class="btn btn-sm btn-success" id="add-salary-guarantee">
                                                <i class="fas fa-briefcase mr-1"></i>Add Salary Guarantee
                                            </button>
                                            <button type="button" class="btn btn-sm btn-info" id="add-collateral-guarantee">
                                                <i class="fas fa-home mr-1"></i>Add Collateral
                                            </button>
                                            <button type="button" class="btn btn-sm btn-primary" id="add-guarantor">
                                                <i class="fas fa-users mr-1"></i>Add Guarantor
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div id="guarantees-container">
                                            <!-- Existing guarantees will be loaded here -->
                                            <?php $__currentLoopData = $loan->guarantees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $guarantee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="<?php echo e($guarantee->guarantee_type); ?>" data-index="<?php echo e($index); ?>">
                                                <div class="d-flex justify-content-between align-items-center mb-3">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-<?php echo e($guarantee->guarantee_type === 'salary' ? 'briefcase text-success' : ($guarantee->guarantee_type === 'collateral' ? 'home text-info' : 'users text-primary')); ?> mr-2"></i>
                                                        <?php echo e($guarantee->type_label); ?>

                                                        <span class="badge badge-<?php echo e($guarantee->status_color); ?> ml-2"><?php echo e(ucfirst($guarantee->status)); ?></span>
                                                    </h6>
                                                    <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                                <input type="hidden" name="existing_guarantees[<?php echo e($index); ?>][id]" value="<?php echo e($guarantee->id); ?>">
                                                <input type="hidden" name="existing_guarantees[<?php echo e($index); ?>][type]" value="<?php echo e($guarantee->guarantee_type); ?>">

                                                <?php if($guarantee->guarantee_type === 'salary' && $guarantee->salaryGuarantee): ?>
                                                    <?php $salary = $guarantee->salaryGuarantee; ?>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Employer Name</label>
                                                                <input type="text" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][salary][employer_name]" value="<?php echo e($salary->employer_name); ?>" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Employer Phone</label>
                                                                <input type="tel" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][salary][employer_phone]" value="<?php echo e($salary->employer_phone); ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-8">
                                                            <div class="form-group">
                                                                <label>Employer Address</label>
                                                                <input type="text" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][salary][employer_address]" value="<?php echo e($salary->employer_address); ?>" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>Monthly Salary (KSh)</label>
                                                                <input type="number" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][salary][monthly_salary]" value="<?php echo e($salary->monthly_salary); ?>" min="0" step="0.01" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Employee Position</label>
                                                                <input type="text" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][salary][employee_position]" value="<?php echo e($salary->employee_position); ?>" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Employment Start Date</label>
                                                                <input type="date" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][salary][employment_start_date]" value="<?php echo e($salary->employment_start_date->format('Y-m-d')); ?>" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php elseif($guarantee->guarantee_type === 'collateral'): ?>
                                                    <?php $__currentLoopData = $guarantee->collateral; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Item Type</label>
                                                                <select class="form-control" name="existing_guarantees[<?php echo e($index); ?>][collateral][item_type]" required>
                                                                    <option value="vehicle" <?php echo e($item->item_type === 'vehicle' ? 'selected' : ''); ?>>Vehicle</option>
                                                                    <option value="land" <?php echo e($item->item_type === 'land' ? 'selected' : ''); ?>>Land/Property</option>
                                                                    <option value="house" <?php echo e($item->item_type === 'house' ? 'selected' : ''); ?>>House</option>
                                                                    <option value="machinery" <?php echo e($item->item_type === 'machinery' ? 'selected' : ''); ?>>Machinery/Equipment</option>
                                                                    <option value="other" <?php echo e($item->item_type === 'other' ? 'selected' : ''); ?>>Other</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Estimated Value (KSh)</label>
                                                                <input type="number" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][collateral][estimated_value]" value="<?php echo e($item->estimated_value); ?>" min="0" step="0.01" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Item Description</label>
                                                                <textarea class="form-control" name="existing_guarantees[<?php echo e($index); ?>][collateral][item_description]" rows="2" required><?php echo e($item->item_description); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php elseif($guarantee->guarantee_type === 'guarantor'): ?>
                                                    <?php $__currentLoopData = $guarantee->guarantors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $guarantor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="row">
                                                        <div class="col-md-8">
                                                            <div class="form-group">
                                                                <label>Guarantor (Member)</label>
                                                                <select class="form-control guarantor-select" name="existing_guarantees[<?php echo e($index); ?>][guarantor][guarantor_user_id]" required>
                                                                    <option value="">Select Guarantor</option>
                                                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($user->id); ?>" <?php echo e($guarantor->guarantor_user_id == $user->id ? 'selected' : ''); ?>><?php echo e($user->full_name); ?> (<?php echo e($user->id_number); ?>)</option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label>Guarantee Amount (KSh)</label>
                                                                <input type="number" class="form-control" name="existing_guarantees[<?php echo e($index); ?>][guarantor][guarantee_amount]" value="<?php echo e($guarantor->guarantee_amount); ?>" min="0" step="0.01" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <div id="new-guarantees-container">
                                            <!-- Dynamic new guarantees will be added here -->
                                        </div>
                                        <?php $__errorArgs = ['guarantee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="alert alert-danger mt-3">
                                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                                <strong><?php echo e($message); ?></strong>
                                            </div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        <div class="text-muted mt-3">
                                            <small><i class="fas fa-info-circle mr-1"></i>
                                                Add at least one form of security/guarantee for the loan application.
                                                Salary guarantees require employment documents, collateral requires ownership documents,
                                                and guarantors must be registered members with active savings for more than 3 months.
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Update Loan Application</button>
                        <a href="<?php echo e(route('loans.index')); ?>" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
$(document).ready(function() {
    // Show success message if it exists
    <?php if(session('success')): ?>
        toastr.success('<?php echo e(session('success')); ?>');
    <?php endif; ?>

    // Show error message if it exists
    <?php if(session('error')): ?>
        toastr.error('<?php echo e(session('error')); ?>');
    <?php endif; ?>
    let guaranteeCounter = <?php echo e($loan->guarantees->count()); ?>;

    function calculateLoan() {
        var amount = parseFloat($('#amount').val()) || 0;
        var interestRate = parseFloat($('#interest_rate').val()) || 0;
        var applicationDate = $('#application_date').val();
        var returnDate = $('#return_date').val();

        var termMonths = 0;
        if (applicationDate && returnDate) {
            var startDate = new Date(applicationDate);
            var endDate = new Date(returnDate);
            var timeDiff = endDate.getTime() - startDate.getTime();
            termMonths = Math.ceil(timeDiff / (1000 * 3600 * 24 * 30)); // Approximate months
            termMonths = Math.max(1, termMonths); // Minimum 1 month
        }

        var interestAmount = amount * (interestRate / 100);
        var totalAmount = amount + interestAmount;
        var monthlyPayment = termMonths > 0 ? totalAmount / termMonths : 0;

        $('#preview-principal').text('KSh ' + amount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-interest').text('KSh ' + interestAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-total').text('KSh ' + totalAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#preview-monthly').text('KSh ' + monthlyPayment.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
    }

    $('#amount, #interest_rate, #application_date, #return_date').on('input change', calculateLoan);
    calculateLoan(); // Initial calculation

    // Add Salary Guarantee
    $('#add-salary-guarantee').on('click', function() {
        addSalaryGuarantee();
    });

    // Add Collateral Guarantee
    $('#add-collateral-guarantee').on('click', function() {
        addCollateralGuarantee();
    });

    // Add Guarantor
    $('#add-guarantor').on('click', function() {
        addGuarantor();
    });

    function addSalaryGuarantee() {
        const index = guaranteeCounter++;
        const html = `
            <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="salary" data-index="${index}">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0"><i class="fas fa-briefcase text-success mr-2"></i>Salary Guarantee</h6>
                    <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
                <input type="hidden" name="guarantees[${index}][type]" value="salary">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employer Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="guarantees[${index}][salary][employer_name]" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employer Phone</label>
                            <input type="tel" class="form-control" name="guarantees[${index}][salary][employer_phone]">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label>Employer Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="guarantees[${index}][salary][employer_address]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Monthly Salary (KSh) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="guarantees[${index}][salary][monthly_salary]" min="0" step="0.01" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employee Position <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="guarantees[${index}][salary][employee_position]" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Employment Start Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" name="guarantees[${index}][salary][employment_start_date]" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Employment Letter</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][salary][employment_letter]" accept=".pdf,.doc,.docx">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Confirmation Letter</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][salary][confirmation_letter]" accept=".pdf,.doc,.docx">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Payslips (2 months)</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][salary][payslips][]" multiple accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>
                    </div>
                </div>
            </div>
        `;
        $('#new-guarantees-container').append(html);
    }

    function addCollateralGuarantee() {
        const index = guaranteeCounter++;
        const html = `
            <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="collateral" data-index="${index}">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0"><i class="fas fa-home text-info mr-2"></i>Collateral Guarantee</h6>
                    <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
                <input type="hidden" name="guarantees[${index}][type]" value="collateral">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Item Type <span class="text-danger">*</span></label>
                            <select class="form-control" name="guarantees[${index}][collateral][item_type]" required>
                                <option value="">Select Item Type</option>
                                <option value="vehicle">Vehicle</option>
                                <option value="land">Land/Property</option>
                                <option value="house">House</option>
                                <option value="machinery">Machinery/Equipment</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Estimated Value (KSh) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="guarantees[${index}][collateral][estimated_value]" min="0" step="0.01" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Item Description <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="guarantees[${index}][collateral][item_description]" rows="2" required></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Ownership Document Type <span class="text-danger">*</span></label>
                            <select class="form-control" name="guarantees[${index}][collateral][ownership_document_type]" required>
                                <option value="">Select Document Type</option>
                                <option value="title_deed">Title Deed</option>
                                <option value="log_book">Log Book</option>
                                <option value="receipt">Purchase Receipt</option>
                                <option value="certificate">Ownership Certificate</option>
                                <option value="other">Other Document</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Document Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="guarantees[${index}][collateral][ownership_document_number]" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Document Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" name="guarantees[${index}][collateral][ownership_document_date]" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Ownership Document</label>
                            <input type="file" class="form-control-file" name="guarantees[${index}][collateral][document_file]" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Ownership Details</label>
                            <textarea class="form-control" name="guarantees[${index}][collateral][ownership_details]" rows="2" placeholder="Additional ownership information"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        `;
        $('#new-guarantees-container').append(html);
    }

    function addGuarantor() {
        const index = guaranteeCounter++;
        const html = `
            <div class="guarantee-item border rounded p-3 mb-3 bg-light" data-type="guarantor" data-index="${index}">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0"><i class="fas fa-users text-primary mr-2"></i>Guarantor</h6>
                    <button type="button" class="btn btn-sm btn-outline-danger remove-guarantee">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
                <input type="hidden" name="guarantees[${index}][type]" value="guarantor">
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label>Guarantor (Member) <span class="text-danger">*</span></label>
                            <select class="form-control guarantor-select" name="guarantees[${index}][guarantor][guarantor_user_id]" required>
                                <option value="">Select Guarantor</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->full_name); ?> (<?php echo e($user->id_number); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Guarantee Amount (KSh) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="guarantees[${index}][guarantor][guarantee_amount]" min="0" step="0.01" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Relationship Type <span class="text-danger">*</span></label>
                            <select class="form-control" name="guarantees[${index}][guarantor][relationship_type]" required>
                                <option value="">Select Relationship</option>
                                <option value="family">Family Member</option>
                                <option value="friend">Friend</option>
                                <option value="colleague">Colleague</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Relationship Details</label>
                            <input type="text" class="form-control" name="guarantees[${index}][guarantor][relationship_details]" placeholder="Additional relationship details">
                        </div>
                    </div>
                </div>
            </div>
        `;
        $('#new-guarantees-container').append(html);
    }

    // Remove guarantee
    $(document).on('click', '.remove-guarantee', function() {
        $(this).closest('.guarantee-item').remove();
    });
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\loans\edit.blade.php ENDPATH**/ ?>