<?php $__env->startSection('title', 'Savings Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
<h2 class="mb-4" style="color: black;">Savings Account</h2>
<!-- Dynamic Statistics Cards - Real-time Savings Overview -->
<div class="row mb-3">
    <!-- Current Total Savings Balance -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Current Balance
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            KSh <?php echo e(number_format($totalCurrentSavings, 0)); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-piggy-bank mr-1"></i>
                            Active & matured
                        </div>
                    </div>
                    <div class="flex-shrink-0">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-coins"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Monthly Net Growth -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-<?php echo e($monthlyNetGrowth >= 0 ? 'success' : 'danger'); ?> shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-<?php echo e($monthlyNetGrowth >= 0 ? 'success' : 'danger'); ?> text-uppercase mb-1">
                            Monthly Growth
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <span class="<?php echo e($monthlyNetGrowth >= 0 ? 'text-success' : 'text-danger'); ?>">
                                <?php echo e($monthlyNetGrowth >= 0 ? '+' : ''); ?>KSh <?php echo e(number_format(abs($monthlyNetGrowth), 0)); ?>

                            </span>
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-<?php echo e($monthlyNetGrowth >= 0 ? 'arrow-up' : 'arrow-down'); ?> mr-1"></i>
                            <?php echo e(date('M Y')); ?> change
                        </div>
                    </div>
                    <div class="flex-shrink-0">
                        <div class="bg-<?php echo e($monthlyNetGrowth >= 0 ? 'success' : 'danger'); ?> text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Accounts -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Active Accounts
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($activeAccounts); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-play-circle mr-1"></i>
                            <?php echo e($activeAccounts > 0 ? 'Currently active' : 'No active'); ?>

                        </div>
                    </div>
                    <div class="flex-shrink-0">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-play-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Transactions -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-info shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Recent Activity
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($recentTransactions); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-clock mr-1"></i>
                            Last 30 days
                        </div>
                    </div>
                    <div class="flex-shrink-0">
                        <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-history"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Additional Statistics Row -->
<div class="row mb-3">
    <!-- Top Saver -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-secondary shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                            Top Saver
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php if($topSaver): ?>
                                <?php echo e(Str::limit($topSaver->user->full_name, 15)); ?>

                            <?php else: ?>
                                No Data
                            <?php endif; ?>
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-trophy mr-1"></i>
                            <?php if($topSaver): ?>
                                KSh <?php echo e(number_format($topSaver->calculated_balance, 0)); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-trophy"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Most Recent Saver -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Recent Saver
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php if($mostRecentSaver): ?>
                                <?php echo e(Str::limit($mostRecentSaver->user->full_name, 15)); ?>

                            <?php else: ?>
                                No Activity
                            <?php endif; ?>
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-clock mr-1"></i>
                            <?php if($mostRecentSaver && $mostRecentSaver->transactions->last()): ?>
                                <?php echo e($mostRecentSaver->transactions->last()->transaction_date->format('M j')); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Withdrawn -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-danger shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Total Withdrawn
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            KSh <?php echo e(number_format($totalWithdrawnAmount, 0)); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-money-bill-wave mr-1"></i>
                            From <?php echo e($withdrawnAccounts); ?> accounts
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Withdrawer -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-dark shadow-sm compact-savings-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-dark text-uppercase mb-1">
                            Top Withdrawer
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php if($topWithdrawer): ?>
                                <?php echo e(Str::limit($topWithdrawer->user->full_name, 15)); ?>

                            <?php else: ?>
                                No Withdrawals
                            <?php endif; ?>
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-money-bill-wave mr-1"></i>
                            <?php if($topWithdrawer): ?>
                                KSh <?php echo e(number_format($topWithdrawerAmount, 0)); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-dark text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-user-minus"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Savings Table -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Member Savings Accounts</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('savings.create')); ?>" class="btn btn-success btn-sm mr-2" title="Add New Savings Account">
                            <i class="fas fa-plus"></i> Add New
                        </a>
                        <button type="button" class="btn btn-info btn-sm mr-2" onclick="refreshPage()" title="Refresh Data">
                            <i class="fas fa-sync-alt"></i> Refresh
                        </button>
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-secondary btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" title="Export Options">
                                <i class="fas fa-download"></i> Export
                            </button>
                            <div class="dropdown-menu dropdown-menu-right">
                                <a class="dropdown-item" href="<?php echo e(route('savings.export.pdf')); ?>" target="_blank">
                                    <i class="fas fa-file-pdf text-danger mr-2"></i> PDF
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('savings.export.excel')); ?>">
                                    <i class="fas fa-file-excel text-success mr-2"></i> Excel
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('savings.export.csv')); ?>">
                                    <i class="fas fa-file-csv text-info mr-2"></i> CSV
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap table-sm compact-table">
                        <thead class="thead-light">
                            <tr>
                                <th class="compact-th">ID</th>
                                <th class="compact-th">Member</th>
                                <th class="compact-th">Initial</th>
                                <th class="compact-th">Balance</th>
                                <th class="compact-th">Type</th>
                                <th class="compact-th">Status</th>
                                <th class="compact-th d-none d-md-table-cell">Maturity</th>
                                <th class="compact-th d-none d-lg-table-cell">Created</th>
                                <th class="compact-th">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $savings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saving): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="compact-row">
                                <td class="compact-td"><?php echo e($saving->id); ?></td>
                                <td class="compact-td">
                                    <div class="font-weight-medium"><?php echo e(Str::limit($saving->user->full_name ?? 'N/A', 18)); ?></div>
                                </td>
                                <td class="compact-td text-nowrap">KSh <?php echo e(number_format($saving->amount, 0)); ?></td>
                                <td class="compact-td">
                                    <span class="font-weight-bold <?php echo e($saving->current_balance > 0 ? 'text-success' : 'text-muted'); ?>">
                                        KSh <?php echo e(number_format($saving->current_balance, 0)); ?>

                                    </span>
                                    <?php if($saving->current_balance != $saving->amount && $saving->status !== 'withdrawn'): ?>
                                        <br><small class="text-muted text-xs">
                                            <?php echo e($saving->current_balance > $saving->amount ? '+' : ''); ?><?php echo e(number_format($saving->current_balance - $saving->amount, 0)); ?>

                                        </small>
                                    <?php endif; ?>
                                </td>
                                <td class="compact-td">
                                    <span class="badge badge-sm badge-<?php echo e($saving->type_color); ?>">
                                        <?php echo e($saving->type_label); ?>

                                    </span>
                                </td>
                                <td class="compact-td">
                                    <span class="badge badge-sm badge-<?php echo e($saving->status_color); ?>">
                                        <?php echo e($saving->status_label); ?>

                                    </span>
                                </td>
                                <td class="compact-td d-none d-md-table-cell"><?php echo e($saving->maturity_date ? $saving->maturity_date->format('d M Y') : 'N/A'); ?></td>
                                <td class="compact-td d-none d-lg-table-cell"><?php echo e($saving->created_at->format('d M Y')); ?></td>
                                <td class="compact-td">
                                    <div class="btn-group btn-group-xs">
                                        <a href="<?php echo e(route('savings.show', $saving)); ?>" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('savings.edit', $saving)); ?>" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php if($saving->status === 'active'): ?>
                                        <form action="<?php echo e(route('savings.withdraw', $saving)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                            <button type="submit" class="btn btn-warning btn-xs" title="Withdraw" onclick="return confirm('Are you sure you want to withdraw this savings account?')">
                                                <i class="fas fa-money-bill-wave"></i>
                                            </button>
                                        </form>
                                        <?php if($saving->type === 'fixed' && $saving->maturity_date && $saving->maturity_date->isPast()): ?>
                                        <form action="<?php echo e(route('savings.mature', $saving)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                            <button type="submit" class="btn btn-success btn-xs" title="Mark as Matured" onclick="return confirm('Are you sure you want to mark this savings as matured?')">
                                                <i class="fas fa-check-circle"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        <form action="<?php echo e(route('savings.destroy', $saving)); ?>" method="POST" class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this savings account? This action cannot be undone.')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-piggy-bank fa-3x mb-3"></i>
                                        <h5>No Savings Accounts Yet</h5>
                                        <p>Start by adding your first savings account to the system.</p>
                                        <a href="<?php echo e(route('savings.create')); ?>" class="btn btn-success">
                                            <i class="fas fa-plus"></i> Add First Savings Account
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if($savings->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($savings->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

</div>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact savings card styling */
.compact-savings-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-savings-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-savings-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-savings-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

<?php $__env->startPush('js'); ?>
<?php if(session('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?php echo e(session("success")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<?php if(session('error')): ?>
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '<?php echo e(session("error")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<script>
function refreshPage() {
    // Show loading indicator
    const refreshBtn = document.querySelector('button[onclick="refreshPage()"]');
    const originalHtml = refreshBtn.innerHTML;
    refreshBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Refreshing...';
    refreshBtn.disabled = true;

    // Reload the page
    setTimeout(() => {
        window.location.reload();
    }, 500);
}

// Auto-refresh every 5 minutes (300000 milliseconds)
setTimeout(() => {
    if (confirm('Page data may be outdated. Refresh to see latest updates?')) {
        refreshPage();
    }
}, 300000);

// Add visual feedback for successful operations
<?php if(session('success')): ?>
setTimeout(() => {
    // Add a subtle animation to the statistics cards
    const cards = document.querySelectorAll('.card.border-left-success, .card.border-left-primary, .card.border-left-info, .card.border-left-warning, .card.border-left-danger, .card.border-left-dark');
    cards.forEach((card, index) => {
        setTimeout(() => {
            card.style.transform = 'scale(1.02)';
            card.style.boxShadow = '0 8px 25px rgba(0,0,0,0.15)';
            setTimeout(() => {
                card.style.transform = 'scale(1)';
                card.style.boxShadow = '';
            }, 300);
        }, index * 100);
    });
}, 1000);
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\savings\index.blade.php ENDPATH**/ ?>