<?php $__env->startSection('title', 'System Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">System Configuration</h3>
                </div>
                <div class="card-body">
                    <?php
                        $currentCategory = null;
                    ?>
                    <?php $__currentLoopData = $configurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($currentCategory !== $config->category): ?>
                            <?php if($currentCategory !== null): ?>
                                </div>
                            <?php endif; ?>
                            <div class="mb-4">
                                <h4 class="text-primary"><?php echo e(ucfirst($config->category)); ?> Settings</h4>
                                <hr>
                            </div>
                            <?php
                                $currentCategory = $config->category;
                            ?>
                        <?php endif; ?>
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <form action="<?php echo e(route('system-configurations.update', $config->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="form-group">
                                        <label for="config_<?php echo e($config->id); ?>">
                                            <strong><?php echo e(ucwords(str_replace('_', ' ', $config->key))); ?></strong>
                                        </label>
                                        <?php if($config->description): ?>
                                            <small class="form-text text-muted d-block"><?php echo e($config->description); ?></small>
                                        <?php endif; ?>

                                        <?php if($config->key === 'occupation_options'): ?>
                                            <textarea name="value" id="config_<?php echo e($config->id); ?>" class="form-control" rows="6" required>
<?php echo e(is_array($config->parsed_value) ? implode("\n", $config->parsed_value) : $config->value); ?>

                                            </textarea>
                                            <small class="form-text text-muted">Enter each occupation option on a new line</small>
                                        <?php elseif($config->type === 'boolean'): ?>
                                            <select name="value" id="config_<?php echo e($config->id); ?>" class="form-control" required>
                                                <option value="true" <?php echo e($config->parsed_value ? 'selected' : ''); ?>>Yes</option>
                                                <option value="false" <?php echo e(!$config->parsed_value ? 'selected' : ''); ?>>No</option>
                                            </select>
                                        <?php else: ?>
                                            <input type="text" name="value" id="config_<?php echo e($config->id); ?>"
                                                   class="form-control" value="<?php echo e($config->value); ?>" required>
                                        <?php endif; ?>
                                    </div>

                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <i class="fas fa-save"></i> Update
                                    </button>
                                </form>
                            </div>
                        </div>
                        <?php if(!$loop->last): ?>
                            <hr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($currentCategory !== null): ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\system-configurations\index.blade.php ENDPATH**/ ?>