<?php $__env->startSection('title', 'View Communication'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Communication Details</h3>
                    <div class="card-tools">
                        <?php if($communication->status === 'draft'): ?>
                        <a href="<?php echo e(route('communications.edit', $communication)); ?>" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <form action="<?php echo e(route('communications.send', $communication)); ?>" method="POST" class="d-inline ml-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Are you sure you want to send this communication?')">
                                <i class="fas fa-paper-plane"></i> Send Now
                            </button>
                        </form>
                        <?php endif; ?>
                        <a href="<?php echo e(route('communications.index')); ?>" class="btn btn-secondary btn-sm ml-2">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-4">
                                <h4><?php echo e($communication->subject); ?></h4>
                                <hr>
                                <div class="communication-content">
                                    <?php echo nl2br(e($communication->content)); ?>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card border-info">
                                <div class="card-header bg-info">
                                    <h5 class="card-title mb-0 text-white">
                                        <i class="fas fa-info-circle mr-2"></i>Communication Info
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-5">Status:</dt>
                                        <dd class="col-sm-7">
                                            <?php if($communication->status === 'sent'): ?>
                                                <span class="badge badge-success">Sent</span>
                                            <?php elseif($communication->status === 'scheduled'): ?>
                                                <span class="badge badge-warning">Scheduled</span>
                                            <?php else: ?>
                                                <span class="badge badge-secondary">Draft</span>
                                            <?php endif; ?>
                                        </dd>

                                        <dt class="col-sm-5">Priority:</dt>
                                        <dd class="col-sm-7">
                                            <?php if($communication->priority === 'urgent'): ?>
                                                <span class="badge badge-danger">Urgent</span>
                                            <?php elseif($communication->priority === 'high'): ?>
                                                <span class="badge badge-warning">High</span>
                                            <?php elseif($communication->priority === 'normal'): ?>
                                                <span class="badge badge-info">Normal</span>
                                            <?php else: ?>
                                                <span class="badge badge-light">Low</span>
                                            <?php endif; ?>
                                        </dd>

                                        <dt class="col-sm-5">Recipient Type:</dt>
                                        <dd class="col-sm-7"><?php echo e(ucfirst(str_replace('_', ' ', $communication->recipient_type))); ?></dd>

                                        <dt class="col-sm-5">Created By:</dt>
                                        <dd class="col-sm-7"><?php echo e($communication->creator->full_name ?? 'Unknown'); ?></dd>

                                        <dt class="col-sm-5">Created At:</dt>
                                        <dd class="col-sm-7"><?php echo e($communication->created_at->format('M d, Y H:i')); ?></dd>

                                        <?php if($communication->sent_at): ?>
                                        <dt class="col-sm-5">Sent At:</dt>
                                        <dd class="col-sm-7"><?php echo e($communication->sent_at->format('M d, Y H:i')); ?></dd>
                                        <?php endif; ?>

                                        <?php if($communication->scheduled_at): ?>
                                        <dt class="col-sm-5">Scheduled For:</dt>
                                        <dd class="col-sm-7"><?php echo e($communication->scheduled_at->format('M d, Y H:i')); ?></dd>
                                        <?php endif; ?>
                                    </dl>
                                </div>
                            </div>

                            <?php if($communication->recipient_type === 'individual' && $communication->recipient_ids): ?>
                            <div class="card border-success mt-3">
                                <div class="card-header bg-success">
                                    <h5 class="card-title mb-0 text-white">
                                        <i class="fas fa-users mr-2"></i>Recipients (<?php echo e(count($communication->recipient_ids)); ?>)
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled">
                                        <?php $__currentLoopData = $communication->getRecipients(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recipient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="mb-2">
                                            <i class="fas fa-user text-success mr-2"></i>
                                            <?php echo e($recipient->first_name); ?> <?php echo e($recipient->second_name); ?>

                                            <br>
                                            <small class="text-muted"><?php echo e($recipient->email); ?></small>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                            <?php elseif($communication->recipient_type === 'all_members'): ?>
                            <div class="card border-primary mt-3">
                                <div class="card-header bg-primary">
                                    <h5 class="card-title mb-0 text-white">
                                        <i class="fas fa-users mr-2"></i>Recipients
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="mb-0">
                                        <i class="fas fa-info-circle text-primary mr-2"></i>
                                        This communication will be sent to all members.
                                    </p>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
.communication-content {
    line-height: 1.6;
    white-space: pre-wrap;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\communications\show.blade.php ENDPATH**/ ?>