<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Financial Summary Report - <?php echo e(date('Y-m-d')); ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 10px;
        }

        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }

        .header h2 {
            color: #247f1b;
            margin: 5px 0;
            font-size: 14px;
        }

        .header p {
            margin: 2px 0;
            color: #666;
        }

        .section {
            margin-bottom: 20px;
        }

        .section h3 {
            color: #247f1b;
            font-size: 12px;
            margin-bottom: 10px;
            border-bottom: 1px solid #247f1b;
            padding-bottom: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 8px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            text-align: center;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .amount {
            text-align: right;
            font-weight: bold;
        }

        .total-row {
            background-color: #e9ecef !important;
            font-weight: bold;
        }

        .summary-grid {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }

        .summary-item {
            display: table-cell;
            width: 25%;
            text-align: center;
            padding: 10px;
            vertical-align: top;
        }

        .summary-value {
            font-size: 12px;
            font-weight: bold;
            color: #247f1b;
        }

        .summary-label {
            font-size: 8px;
            color: #666;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            border-top: 1px solid #ddd;
            padding-top: 15px;
            font-size: 8px;
            color: #666;
        }

        .page-break {
            page-break-before: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <h2>Financial Summary Report</h2>
        <p>Period: <?php echo e($startDate->format('M d, Y')); ?> - <?php echo e($endDate->format('M d, Y')); ?></p>
        <p>Generated on <?php echo e(date('l, F j, Y \a\t g:i A')); ?></p>
    </div>

    <!-- Income Section -->
    <div class="section">
        <h3>INCOME</h3>
        <table>
            <thead>
                <tr>
                    <th>Source</th>
                    <th style="width: 30%;">Amount (KES)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Savings Deposits</td>
                    <td class="amount"><?php echo e(number_format($data['income']['savings_deposits'], 2)); ?></td>
                </tr>
                <tr>
                    <td>Loan Repayments</td>
                    <td class="amount"><?php echo e(number_format($data['income']['loan_repayments'], 2)); ?></td>
                </tr>
                <tr>
                    <td>Registration Fees</td>
                    <td class="amount"><?php echo e(number_format($data['income']['registration_fees'], 2)); ?></td>
                </tr>
                <tr>
                    <td>Share Purchases</td>
                    <td class="amount"><?php echo e(number_format($data['income']['share_purchases'], 2)); ?></td>
                </tr>
                <tr class="total-row">
                    <td><strong>Total Income</strong></td>
                    <td class="amount"><strong><?php echo e(number_format(array_sum($data['income']), 2)); ?></strong></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Expenses Section -->
    <div class="section">
        <h3>EXPENSES</h3>
        <table>
            <thead>
                <tr>
                    <th>Source</th>
                    <th style="width: 30%;">Amount (KES)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Loan Disbursements</td>
                    <td class="amount"><?php echo e(number_format($data['expenses']['loan_disbursements'], 2)); ?></td>
                </tr>
                <tr>
                    <td>Savings Withdrawals</td>
                    <td class="amount"><?php echo e(number_format($data['expenses']['savings_withdrawals'], 2)); ?></td>
                </tr>
                <tr>
                    <td>Dividend Payments</td>
                    <td class="amount"><?php echo e(number_format($data['expenses']['dividend_payments'], 2)); ?></td>
                </tr>
                <tr>
                    <td>Fee Payments</td>
                    <td class="amount"><?php echo e(number_format($data['expenses']['fee_payments'], 2)); ?></td>
                </tr>
                <tr class="total-row">
                    <td><strong>Total Expenses</strong></td>
                    <td class="amount"><strong><?php echo e(number_format(array_sum($data['expenses']), 2)); ?></strong></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Net Income Summary -->
    <div class="section">
        <h3>NET INCOME SUMMARY</h3>
        <div class="summary-grid">
            <div class="summary-item">
                <div class="summary-value">KES <?php echo e(number_format(array_sum($data['income']), 2)); ?></div>
                <div class="summary-label">Total Income</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KES <?php echo e(number_format(array_sum($data['expenses']), 2)); ?></div>
                <div class="summary-label">Total Expenses</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KES <?php echo e(number_format(array_sum($data['income']) - array_sum($data['expenses']), 2)); ?></div>
                <div class="summary-label">Net Income</div>
            </div>
            <div class="summary-item">
                <div class="summary-value"><?php echo e(number_format($data['period_summary']['total_transactions'])); ?></div>
                <div class="summary-label">Total Transactions</div>
            </div>
        </div>
    </div>

    <!-- Current Balances -->
    <div class="section">
        <h3>CURRENT BALANCES</h3>
        <div class="summary-grid">
            <div class="summary-item">
                <div class="summary-value">KES <?php echo e(number_format($data['balances']['total_savings'], 2)); ?></div>
                <div class="summary-label">Total Savings</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KES <?php echo e(number_format($data['balances']['total_loans_outstanding'], 2)); ?></div>
                <div class="summary-label">Loans Outstanding</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KES <?php echo e(number_format($data['balances']['total_shares'], 2)); ?></div>
                <div class="summary-label">Total Shares</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KES <?php echo e(number_format($data['balances']['total_savings'] + $data['balances']['total_shares'] - $data['balances']['total_loans_outstanding'], 2)); ?></div>
                <div class="summary-label">Net Asset Value</div>
            </div>
        </div>
    </div>

    <!-- Period Summary -->
    <div class="section">
        <h3>PERIOD SUMMARY</h3>
        <div class="summary-grid">
            <div class="summary-item">
                <div class="summary-value"><?php echo e(number_format($data['period_summary']['active_loans'])); ?></div>
                <div class="summary-label">Active Loans</div>
            </div>
            <div class="summary-item">
                <div class="summary-value"><?php echo e(number_format($data['period_summary']['active_savings_accounts'])); ?></div>
                <div class="summary-label">Active Savings Accounts</div>
            </div>
            <div class="summary-item">
                <div class="summary-value"><?php echo e(number_format($data['period_summary']['total_transactions'])); ?></div>
                <div class="summary-label">Total Transactions</div>
            </div>
            <div class="summary-item">
                <div class="summary-value"><?php echo e(number_format(($data['period_summary']['active_loans'] / max($data['period_summary']['total_transactions'], 1)) * 100, 1)); ?>%</div>
                <div class="summary-label">Loan to Transaction Ratio</div>
            </div>
        </div>
    </div>

    <div class="footer">
        <p><strong>Morio Sacco Management System</strong></p>
        <p>Financial Summary Report | Generated on <?php echo e(date('l, F j, Y \a\t g:i A')); ?></p>
        <p>This is an official financial report. Please keep for your records.</p>
    </div>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\reports\exports\financial-summary-pdf.blade.php ENDPATH**/ ?>