<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Savings Receipt - <?php echo e($transaction->transaction_number); ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 10px;
        }

        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 20px;
            font-weight: bold;
        }

        .header h2 {
            color: #247f1b;
            margin: 5px 0;
            font-size: 16px;
        }

        .header p {
            margin: 2px 0;
            color: #666;
        }

        .receipt-number {
            background: #247f1b;
            color: white;
            padding: 8px 15px;
            border-radius: 4px;
            font-weight: bold;
            font-size: 14px;
            display: inline-block;
            margin-bottom: 15px;
        }

        .transaction-details {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }

        .detail-row {
            display: table-row;
        }

        .detail-cell {
            display: table-cell;
            padding: 8px 12px;
            border-bottom: 1px solid #eee;
        }

        .detail-label {
            font-weight: bold;
            width: 35%;
            background: #f8f9fa;
        }

        .detail-value {
            width: 65%;
        }

        .amounts-section {
            margin: 20px 0;
            border: 2px solid #247f1b;
            border-radius: 8px;
            padding: 15px;
        }

        .amounts-title {
            text-align: center;
            font-size: 14px;
            font-weight: bold;
            color: #247f1b;
            margin-bottom: 15px;
        }

        .amounts-grid {
            display: table;
            width: 100%;
        }

        .amount-box {
            display: table-cell;
            width: 33.33%;
            text-align: center;
            padding: 10px;
        }

        .amount-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 5px;
            text-transform: uppercase;
        }

        .amount-value {
            font-size: 16px;
            font-weight: bold;
        }

        .amount-before {
            color: #17a2b8;
        }

        .amount-transaction {
            color: <?php echo e($transaction->type === 'deposit' ? '#28a745' : '#dc3545'); ?>;
        }

        .amount-after {
            color: #247f1b;
        }

        .notes-section {
            margin: 20px 0;
            padding: 10px;
            background: #fff8f8;
            border-left: 4px solid #ff3c30;
        }

        .notes-title {
            font-weight: bold;
            color: #ff3c30;
            margin-bottom: 5px;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            border-top: 1px solid #ddd;
            padding-top: 15px;
            font-size: 10px;
            color: #666;
        }

        .signature-line {
            margin-top: 20px;
            border-top: 1px solid #333;
            width: 200px;
            margin-left: auto;
            margin-right: auto;
            padding-top: 5px;
            text-align: center;
            font-size: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <h2>Savings Transaction Receipt</h2>
        <p>Official Transaction Record</p>
    </div>

    <div style="text-align: center;">
        <div class="receipt-number"><?php echo e($transaction->transaction_number); ?></div>
    </div>

    <div class="transaction-details">
        <div class="detail-row">
            <div class="detail-cell detail-label">Transaction Date & Time:</div>
            <div class="detail-cell detail-value"><?php echo e($transaction->transaction_date->format('l, F j, Y \a\t g:i A')); ?></div>
        </div>
        <div class="detail-row">
            <div class="detail-cell detail-label">Transaction Type:</div>
            <div class="detail-cell detail-value"><?php echo e($transaction->type_label); ?></div>
        </div>
        <div class="detail-row">
            <div class="detail-cell detail-label">Processed By:</div>
            <div class="detail-cell detail-value"><?php echo e($transaction->processor->name ?? 'System Administrator'); ?></div>
        </div>
        <div class="detail-row">
            <div class="detail-cell detail-label">Member Name:</div>
            <div class="detail-cell detail-value"><?php echo e($transaction->account->user->full_name); ?></div>
        </div>
        <div class="detail-row">
            <div class="detail-cell detail-label">ID Number:</div>
            <div class="detail-cell detail-value"><?php echo e($transaction->account->user->id_number); ?></div>
        </div>
        <div class="detail-row">
            <div class="detail-cell detail-label">Account Type:</div>
            <div class="detail-cell detail-value"><?php echo e($transaction->account->type_label); ?></div>
        </div>
        <div class="detail-row">
            <div class="detail-cell detail-label">Account ID:</div>
            <div class="detail-cell detail-value">#<?php echo e($transaction->account->id); ?></div>
        </div>
    </div>

    <div class="amounts-section">
        <div class="amounts-title">Transaction Summary</div>
        <div class="amounts-grid">
            <div class="amount-box">
                <div class="amount-label">Balance Before</div>
                <div class="amount-value amount-before">KSh <?php echo e(number_format($transaction->balance_before, 2)); ?></div>
            </div>
            <div class="amount-box">
                <div class="amount-label"><?php echo e($transaction->type_label); ?> Amount</div>
                <div class="amount-value amount-transaction"><?php echo e($transaction->formatted_amount); ?></div>
            </div>
            <div class="amount-box">
                <div class="amount-label">Balance After</div>
                <div class="amount-value amount-after">KSh <?php echo e(number_format($transaction->balance_after, 2)); ?></div>
            </div>
        </div>
    </div>

    <?php if($transaction->notes): ?>
    <div class="notes-section">
        <div class="notes-title">Transaction Notes:</div>
        <div><?php echo e($transaction->notes); ?></div>
    </div>
    <?php endif; ?>

    <div class="footer">
        <p><strong>Morio Sacco Management System</strong></p>
        <p>This is an official receipt. Transaction processed on <?php echo e($transaction->created_at->format('l, F j, Y \a\t g:i A')); ?></p>
        <p>Please keep this receipt for your records.</p>
    </div>

    <div class="signature-line">
        Authorized Signature
    </div>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\savings\exports\receipt_pdf.blade.php ENDPATH**/ ?>