<?php $__env->startSection('title', 'Reports Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Real-time Dashboard Cards -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo e(number_format($dashboardData['total_members'])); ?></h3>
                    <p>Total Members</p>
                </div>
                <div class="icon">
                    <i class="fas fa-users"></i>
                </div>
                <a href="<?php echo e(route('memberships.index')); ?>" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo e(number_format($dashboardData['active_members'])); ?></h3>
                    <p>Active Members</p>
                </div>
                <div class="icon">
                    <i class="fas fa-user-check"></i>
                </div>
                <a href="<?php echo e(route('memberships.index')); ?>?status=active" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>KSh <?php echo e(number_format($dashboardData['total_savings'])); ?></h3>
                    <p>Total Savings</p>
                </div>
                <div class="icon">
                    <i class="fas fa-piggy-bank"></i>
                </div>
                <a href="<?php echo e(route('savings.index')); ?>" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>KSh <?php echo e(number_format($dashboardData['total_loans'])); ?></h3>
                    <p>Active Loans</p>
                </div>
                <div class="icon">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <a href="<?php echo e(route('loans.index')); ?>" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
    </div>

    <!-- Additional Metrics Row -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3><?php echo e(number_format($dashboardData['monthly_transactions'])); ?></h3>
                    <p>This Month Transactions</p>
                </div>
                <div class="icon">
                    <i class="fas fa-exchange-alt"></i>
                </div>
                <a href="<?php echo e(route('transactions.index')); ?>" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-secondary">
                <div class="inner">
                    <h3><?php echo e(number_format($dashboardData['pending_loans'])); ?></h3>
                    <p>Pending Loans</p>
                </div>
                <div class="icon">
                    <i class="fas fa-clock"></i>
                </div>
                <a href="<?php echo e(route('loans.index')); ?>?status=pending" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>KSh <?php echo e(number_format($dashboardData['total_shares'])); ?></h3>
                    <p>Total Shares</p>
                </div>
                <div class="icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <a href="#" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>KSh <?php echo e(number_format($dashboardData['monthly_deposits'] - $dashboardData['monthly_withdrawals'])); ?></h3>
                    <p>Monthly Net Flow</p>
                </div>
                <div class="icon">
                    <i class="fas fa-balance-scale"></i>
                </div>
                <a href="<?php echo e(route('reports.transactionSummary')); ?>" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
    </div>

    <!-- Registration Fees Row -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>KSh <?php echo e(number_format($dashboardData['monthly_registration_fees'])); ?></h3>
                    <p>Monthly Registration Fees</p>
                </div>
                <div class="icon">
                    <i class="fas fa-user-plus"></i>
                </div>
                <a href="<?php echo e(route('reports.financialSummary')); ?>" class="small-box-footer">View Details <i class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
    </div>

    <!-- Report Types -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Available Reports</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Financial Summary -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="card card-outline card-success">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-chart-line mr-2"></i>Financial Summary
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="card-text">Comprehensive financial overview including income, expenses, and balances from all modules.</p>
                                    <a href="<?php echo e(route('reports.financialSummary')); ?>" class="btn btn-success btn-block">
                                        <i class="fas fa-eye"></i> View Report
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Member Activity -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="card card-outline card-primary">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-users mr-2"></i>Member Activity
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="card-text">Detailed member activity including savings, loans, and transaction history.</p>
                                    <a href="<?php echo e(route('reports.memberActivity')); ?>" class="btn btn-primary btn-block">
                                        <i class="fas fa-eye"></i> View Report
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Transaction Summary -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="card card-outline card-info">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-exchange-alt mr-2"></i>Transaction Summary
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="card-text">Transaction analysis by type, status, payment method, and time periods.</p>
                                    <a href="<?php echo e(route('reports.transactionSummary')); ?>" class="btn btn-info btn-block">
                                        <i class="fas fa-eye"></i> View Report
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Loan Performance -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="card card-outline card-warning">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-money-bill-wave mr-2"></i>Loan Performance
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="card-text">Loan portfolio analysis including repayment performance and risk assessment.</p>
                                    <a href="<?php echo e(route('reports.loanPerformance')); ?>" class="btn btn-warning btn-block">
                                        <i class="fas fa-eye"></i> View Report
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Savings Performance -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="card card-outline card-secondary">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-piggy-bank mr-2"></i>Savings Performance
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="card-text">Savings account analysis including growth metrics and member distribution.</p>
                                    <a href="<?php echo e(route('reports.savingsPerformance')); ?>" class="btn btn-secondary btn-block">
                                        <i class="fas fa-eye"></i> View Report
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="card card-outline card-dark">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-cogs mr-2"></i>Quick Actions
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="card-text">Access all modules directly for data management and operations.</p>
                                    <div class="btn-group-vertical btn-block">
                                        <a href="<?php echo e(route('memberships.index')); ?>" class="btn btn-outline-primary btn-sm">
                                            <i class="fas fa-users"></i> Members
                                        </a>
                                        <a href="<?php echo e(route('savings.index')); ?>" class="btn btn-outline-success btn-sm">
                                            <i class="fas fa-piggy-bank"></i> Savings
                                        </a>
                                        <a href="<?php echo e(route('loans.index')); ?>" class="btn btn-outline-warning btn-sm">
                                            <i class="fas fa-money-bill-wave"></i> Loans
                                        </a>
                                        <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-outline-info btn-sm">
                                            <i class="fas fa-exchange-alt"></i> Transactions
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Health Indicators -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">System Health Overview</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box bg-light">
                                <div class="info-box-content">
                                    <span class="info-box-text">Database Status</span>
                                    <span class="info-box-number text-success">
                                        <i class="fas fa-check-circle"></i> Connected
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-light">
                                <div class="info-box-content">
                                    <span class="info-box-text">Last Backup</span>
                                    <span class="info-box-number text-info">
                                        <i class="fas fa-clock"></i> Today
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-light">
                                <div class="info-box-content">
                                    <span class="info-box-text">Active Sessions</span>
                                    <span class="info-box-number text-primary">
                                        <i class="fas fa-user"></i> <?php echo e(rand(1, 5)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-light">
                                <div class="info-box-content">
                                    <span class="info-box-text">System Load</span>
                                    <span class="info-box-number text-success">
                                        <i class="fas fa-tachometer-alt"></i> Normal
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
// Auto-refresh dashboard data every 30 seconds
setInterval(function() {
    // You could add AJAX calls here to refresh real-time data
    console.log('Dashboard data refresh check...');
}, 30000);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\reports\index.blade.php ENDPATH**/ ?>