

<?php $__env->startSection('title', 'Financial Summary Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Date Range Filter -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('reports.financialSummary')); ?>" class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Start Date</label>
                                <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate->format('Y-m-d')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>End Date</label>
                                <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate->format('Y-m-d')); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-search"></i> Generate Report
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Export Options -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="btn-group">
                <a href="<?php echo e(route('reports.financialSummary', array_merge(request()->query(), ['export' => 'pdf', 'format' => 'pdf']))); ?>"
                   class="btn btn-danger" target="_blank">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="<?php echo e(route('reports.financialSummary', array_merge(request()->query(), ['export' => 'excel', 'format' => 'excel']))); ?>"
                   class="btn btn-success" target="_blank">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
        </div>
    </div>

    <!-- Income Section -->
    <div class="row">
        <div class="col-md-6">
            <div class="card card-success">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-arrow-up mr-2"></i>Income
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Source</th>
                                    <th class="text-right">Amount (KES)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Savings Deposits</td>
                                    <td class="text-right text-success"><?php echo e(number_format($data['income']['savings_deposits'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Loan Repayments</td>
                                    <td class="text-right text-success"><?php echo e(number_format($data['income']['loan_repayments'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Registration Fees</td>
                                    <td class="text-right text-success"><?php echo e(number_format($data['income']['registration_fees'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Share Purchases</td>
                                    <td class="text-right text-success"><?php echo e(number_format($data['income']['share_purchases'], 2)); ?></td>
                                </tr>
                                <tr class="table-primary">
                                    <td><strong>Total Income</strong></td>
                                    <td class="text-right"><strong><?php echo e(number_format(array_sum($data['income']), 2)); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Expenses Section -->
        <div class="col-md-6">
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-arrow-down mr-2"></i>Expenses
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Source</th>
                                    <th class="text-right">Amount (KES)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Loan Disbursements</td>
                                    <td class="text-right text-danger"><?php echo e(number_format($data['expenses']['loan_disbursements'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Savings Withdrawals</td>
                                    <td class="text-right text-danger"><?php echo e(number_format($data['expenses']['savings_withdrawals'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Dividend Payments</td>
                                    <td class="text-right text-danger"><?php echo e(number_format($data['expenses']['dividend_payments'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Fee Payments</td>
                                    <td class="text-right text-danger"><?php echo e(number_format($data['expenses']['fee_payments'], 2)); ?></td>
                                </tr>
                                <tr class="table-danger">
                                    <td><strong>Total Expenses</strong></td>
                                    <td class="text-right"><strong><?php echo e(number_format(array_sum($data['expenses']), 2)); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Net Income Summary -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Net Income Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-4">
                            <div class="info-box bg-success">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Income</span>
                                    <span class="info-box-number">KSh <?php echo e(number_format(array_sum($data['income']), 2)); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-danger">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Expenses</span>
                                    <span class="info-box-number">KSh <?php echo e(number_format(array_sum($data['expenses']), 2)); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-primary">
                                <div class="info-box-content">
                                    <span class="info-box-text">Net Income</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format(array_sum($data['income']) - array_sum($data['expenses']), 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Balances Section -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Current Balances</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box bg-warning">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Savings</span>
                                    <span class="info-box-number">KSh <?php echo e(number_format($data['balances']['total_savings'], 2)); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-info">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Loans Outstanding</span>
                                    <span class="info-box-number">KSh <?php echo e(number_format($data['balances']['total_loans_outstanding'], 2)); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-secondary">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Shares</span>
                                    <span class="info-box-number">KSh <?php echo e(number_format($data['balances']['total_shares'], 2)); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Period Summary -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Period Summary (<?php echo e($startDate->format('M d, Y')); ?> - <?php echo e($endDate->format('M d, Y')); ?>)</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3><?php echo e(number_format($data['period_summary']['total_transactions'])); ?></h3>
                                    <p>Total Transactions</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-exchange-alt"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3><?php echo e(number_format($data['period_summary']['active_loans'])); ?></h3>
                                    <p>Active Loans</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3><?php echo e(number_format($data['period_summary']['active_savings_accounts'])); ?></h3>
                                    <p>Active Savings Accounts</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-piggy-bank"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3><?php echo e(number_format($data['balances']['total_savings'] + $data['balances']['total_shares'] - $data['balances']['total_loans_outstanding'], 2)); ?></h3>
                                    <p>Net Asset Value</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-balance-scale"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\reports\financial-summary.blade.php ENDPATH**/ ?>