

<?php $__env->startSection('title', 'Branch Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e($branch->name); ?> Branch</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('branches.edit', $branch)); ?>" class="btn btn-outline-warning btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>
                        <a href="<?php echo e(route('branches.index')); ?>" class="btn btn-outline-secondary btn-sm ml-1">
                            <i class="fas fa-arrow-left"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <table class="table table-bordered">
                                <tr>
                                    <th class="bg-light" style="width: 200px;">Branch ID</th>
                                    <td><?php echo e($branch->id); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Branch Name</th>
                                    <td><strong><?php echo e($branch->name); ?></strong></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Location</th>
                                    <td><?php echo e($branch->location); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Contact</th>
                                    <td><?php echo e($branch->contact ?? 'Not specified'); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Manager</th>
                                    <td><?php echo e($branch->manager ?? 'Not assigned'); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Description</th>
                                    <td><?php echo e($branch->description ?? 'No description available'); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Total Members</th>
                                    <td>
                                        <span class="badge badge-info badge-lg">
                                            <?php echo e($branch->users()->count()); ?> members
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Created</th>
                                    <td><?php echo e($branch->created_at->format('d M Y H:i')); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Last Updated</th>
                                    <td><?php echo e($branch->updated_at->format('d M Y H:i')); ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-users"></i> Branch Members
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        <h2 class="text-primary"><?php echo e($branch->users()->count()); ?></h2>
                                        <p class="text-muted mb-0">Total registered members</p>
                                    </div>
                                    <?php if($branch->users()->count() > 0): ?>
                                        <hr>
                                        <p class="small text-muted">Recent members:</p>
                                        <ul class="list-unstyled">
                                            <?php $__currentLoopData = $branch->users()->latest()->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="small">
                                                <i class="fas fa-user text-primary"></i>
                                                <?php echo e($user->first_name); ?> <?php echo e($user->second_name); ?>

                                            </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($branch->users()->count() > 3): ?>
                                            <li class="small text-muted">... and <?php echo e($branch->users()->count() - 3); ?> more</li>
                                            <?php endif; ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="card border-success mt-3">
                                <div class="card-header bg-success text-white">
                                    <h6 class="card-title mb-0">
                                        <i class="fas fa-info-circle"></i> Branch Status
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled small mb-0">
                                        <li><i class="fas fa-check-circle text-success"></i> Branch is active</li>
                                        <li><i class="fas fa-map-marker-alt text-success"></i> Location: <?php echo e($branch->location); ?></li>
                                        <?php if($branch->contact): ?>
                                        <li><i class="fas fa-phone text-success"></i> Contact available</li>
                                        <?php endif; ?>
                                        <?php if($branch->manager): ?>
                                        <li><i class="fas fa-user-tie text-success"></i> Manager assigned</li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Branch Code:</strong> BR<?php echo e(str_pad($branch->id, 3, '0', STR_PAD_LEFT)); ?>

                            </small>
                        </div>
                        <div class="col-md-6 text-right">
                            <form action="<?php echo e(route('branches.destroy', $branch)); ?>" method="POST" class="d-inline"
                                  onsubmit="return confirm('Are you sure you want to delete this branch? This will affect all associated members.')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-outline-danger btn-sm">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Members List -->
    <?php if($branch->users()->count() > 0): ?>
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Branch Members</h3>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Member Name</th>
                                <th>ID Number</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Membership Status</th>
                                <th>Joined</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $branch->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($user->id); ?></td>
                                <td><?php echo e($user->first_name); ?> <?php echo e($user->second_name); ?></td>
                                <td><?php echo e($user->id_number); ?></td>
                                <td><?php echo e($user->phone_number); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td>
                                    <?php if($user->membership): ?>
                                        <span class="badge badge-<?php echo e($user->membership->status === 'active' ? 'success' : 'warning'); ?>">
                                            <?php echo e(ucfirst($user->membership->status)); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">No Membership</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($user->created_at->format('d M Y')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\branches\show.blade.php ENDPATH**/ ?>