<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Welcome Section -->
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">My Money Market Investments</h4>
                    <p class="card-text">Track your fixed-term investments and monitor their growth over time.</p>
                    <a href="<?php echo e(route('member.money-market.calculator')); ?>" class="btn btn-outline-primary">
                        <i class="fas fa-calculator"></i> Investment Calculator
                    </a>
                </div>
            </div>

            <!-- Statistics Cards -->
            <?php if($stats['total_accounts'] > 0): ?>
            <div class="row mt-4">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3><?php echo e(number_format($stats['total_accounts'])); ?></h3>
                            <p>Total Investments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3><?php echo e(number_format($stats['active_accounts'])); ?></h3>
                            <p>Active Investments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-play-circle"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3><?php echo e(number_format($stats['matured_accounts'])); ?></h3>
                            <p>Matured Investments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-primary">
                        <div class="inner">
                            <h3><?php echo e(\App\Helpers\CurrencyHelper::format($stats['total_value'], 'KES')); ?></h3>
                            <p>Total Portfolio Value</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Investments Table -->
            <div class="card mt-4">
                <div class="card-header">
                    <h3 class="card-title">My Investments</h3>
                </div>
                <div class="card-body">
                    <?php if($moneyMarketAccounts->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Account Number</th>
                                    <th>Principal Amount</th>
                                    <th>Interest Rate</th>
                                    <th>Term</th>
                                    <th>Start Date</th>
                                    <th>Maturity Date</th>
                                    <th>Interest Earned</th>
                                    <th>Total Value</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $moneyMarketAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($account->account_number); ?></td>
                                    <td><?php echo e(\App\Helpers\CurrencyHelper::format($account->principal_amount, $account->currency_code)); ?></td>
                                    <td><?php echo e(number_format($account->interest_rate, 2)); ?>%</td>
                                    <td><?php echo e($account->term_months); ?> months</td>
                                    <td><?php echo e($account->start_date->format('M d, Y')); ?></td>
                                    <td><?php echo e($account->maturity_date->format('M d, Y')); ?></td>
                                    <td><?php echo e(\App\Helpers\CurrencyHelper::format($account->interest_earned, $account->currency_code)); ?></td>
                                    <td><?php echo e(\App\Helpers\CurrencyHelper::format($account->total_amount, $account->currency_code)); ?></td>
                                    <td>
                                        <span class="badge <?php echo e($account->getStatusBadgeClass()); ?>">
                                            <?php echo e(ucfirst($account->status)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('member.money-market.show', $account)); ?>" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <?php if($account->status === 'active' || $account->status === 'matured'): ?>
                                        <button type="button" class="btn btn-danger btn-sm ml-1" onclick="requestWithdrawal(<?php echo e($account->id); ?>, '<?php echo e($account->account_number); ?>')">
                                            <i class="fas fa-money-bill-wave"></i> Withdraw
                                        </button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                        <h4>No Money Market Investments Yet</h4>
                        <p class="text-muted">You don't have any money market investments at the moment.</p>
                        <p class="text-muted">Contact your Sacco administrator to open a money market account.</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
function requestWithdrawal(accountId, accountNumber) {
    const reason = prompt(`Please provide a reason for withdrawing from account ${accountNumber}:`);
    if (reason !== null && reason.trim() !== '') {
        if (confirm('Are you sure you want to request withdrawal from this account? This action cannot be undone and requires admin approval.')) {
            // Create a form and submit it
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `<?php echo e(url('member/money-market')); ?>/${accountId}/request-withdrawal`;

            const tokenInput = document.createElement('input');
            tokenInput.type = 'hidden';
            tokenInput.name = '_token';
            tokenInput.value = '<?php echo e(csrf_token()); ?>';

            const amountInput = document.createElement('input');
            amountInput.type = 'hidden';
            amountInput.name = 'withdrawal_amount';
            amountInput.value = '0'; // Full withdrawal

            const reasonInput = document.createElement('input');
            reasonInput.type = 'hidden';
            reasonInput.name = 'reason';
            reasonInput.value = reason;

            form.appendChild(tokenInput);
            form.appendChild(amountInput);
            form.appendChild(reasonInput);
            document.body.appendChild(form);
            form.submit();
        }
    } else if (reason !== null) {
        alert('Please provide a reason for the withdrawal request.');
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views/member/money-market/index.blade.php ENDPATH**/ ?>