<?php $__env->startSection('title', 'Loan Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <!-- Header Section -->
        <div class="mb-6">
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-hand-holding-usd text-green-600 text-base"></i>
                        </div>
                        <div>
                            <h1 class="text-xl lg:text-2xl font-bold text-gray-900">
                                Loan Application #<?php echo e($loan->id); ?>

                            </h1>
                            <p class="mt-1 text-gray-600 text-sm flex items-center">
                                <i class="fas fa-calendar-alt mr-2 text-gray-400"></i>
                                Applied on <?php echo e($loan->created_at->format('F d, Y \a\t H:i')); ?>

                            </p>
                        </div>
                    </div>
                    <div class="flex items-center space-x-4">
                        <span class="inline-flex items-center px-3 py-1.5 rounded-md text-sm font-medium
                            <?php if($loan->status === 'approved'): ?> bg-green-100 text-green-800
                            <?php elseif($loan->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                            <?php elseif($loan->status === 'rejected'): ?> bg-red-100 text-red-800
                            <?php elseif($loan->status === 'active'): ?> bg-blue-100 text-blue-800
                            <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                            <i class="fas
                                <?php if($loan->status === 'approved'): ?> fa-check-circle
                                <?php elseif($loan->status === 'pending'): ?> fa-clock
                                <?php elseif($loan->status === 'rejected'): ?> fa-times-circle
                                <?php elseif($loan->status === 'active'): ?> fa-play-circle
                                <?php else: ?> fa-question-circle <?php endif; ?> mr-1.5 text-xs"></i>
                            <?php echo e(ucfirst($loan->status)); ?>

                        </span>
                    </div>
                </div>
            </div>
        </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 lg:gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-8">
            <!-- Loan Overview Cards -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-3 md:gap-4">
                <div class="bg-white rounded-md shadow-sm border border-gray-200 p-3 md:p-4">
                    <div class="flex flex-col items-center text-center space-y-2">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-money-bill-wave text-green-600 text-sm md:text-base"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide mb-1">Principal</p>
                            <p class="text-sm md:text-lg font-semibold text-gray-900">
                                KSh <?php echo e(number_format($loan->amount, 0)); ?>

                            </p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-md shadow-sm border border-gray-200 p-3 md:p-4">
                    <div class="flex flex-col items-center text-center space-y-2">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-percent text-green-600 text-sm md:text-base"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide mb-1">Rate</p>
                            <p class="text-sm md:text-lg font-semibold text-gray-900">
                                <?php echo e($loan->interest_rate); ?>%
                            </p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-md shadow-sm border border-gray-200 p-3 md:p-4">
                    <div class="flex flex-col items-center text-center space-y-2">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calendar text-green-600 text-sm md:text-base"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide mb-1">Term</p>
                            <p class="text-sm md:text-lg font-semibold text-gray-900">
                                <?php echo e($loan->term_months); ?>m
                            </p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-md shadow-sm border border-gray-200 p-3 md:p-4">
                    <div class="flex flex-col items-center text-center space-y-2">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-coins text-green-600 text-sm md:text-base"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide mb-1">Monthly</p>
                            <p class="text-sm md:text-lg font-semibold text-gray-900">
                                KSh <?php echo e(number_format($loan->monthly_payment, 0)); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Amount Highlight -->
            <div class="bg-green-50 rounded-lg border border-green-200 p-4 md:p-6">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 md:gap-4">
                    <div class="flex items-center space-x-3 md:space-x-4">
                        <div class="w-10 h-10 md:w-12 md:h-12 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calculator text-green-600 text-base md:text-lg"></i>
                        </div>
                        <div>
                            <h3 class="text-base md:text-lg font-semibold text-gray-900 mb-1">Total Loan Amount</h3>
                            <p class="text-gray-600 text-sm">Principal + Interest</p>
                            <div class="flex items-center mt-2">
                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-green-100 text-green-800">
                                    <i class="fas fa-clock mr-1"></i>
                                    <?php echo e($loan->term_months); ?> months
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="text-center sm:text-right mt-3 sm:mt-0">
                        <div class="text-2xl md:text-3xl lg:text-4xl font-bold text-gray-900 mb-1">KSh <?php echo e(number_format($loan->total_amount, 0)); ?></div>
                        <div class="text-gray-600 text-sm">Monthly: KSh <?php echo e(number_format($loan->monthly_payment, 0)); ?></div>
                    </div>
                </div>
            </div>

            <!-- Loan Purpose -->
            <?php if($loan->notes): ?>
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4">
                <div class="flex items-start space-x-3">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-gray-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-comment text-gray-600 text-sm"></i>
                        </div>
                    </div>
                    <div class="flex-1 min-w-0">
                        <h3 class="text-base font-semibold text-gray-900 mb-2">Loan Purpose</h3>
                        <p class="text-gray-600 text-sm leading-relaxed"><?php echo e($loan->notes); ?></p>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Payment Schedule -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                <div class="px-4 py-3 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-base font-semibold text-gray-900 flex items-center">
                        <i class="fas fa-calendar-alt mr-2 text-green-600"></i>
                        Payment Schedule
                    </h3>
                    <p class="text-gray-600 text-sm mt-1">Monthly repayment breakdown</p>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full min-w-[280px]">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-3 md:px-4 py-2 md:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Month</th>
                                <th class="px-3 md:px-4 py-2 md:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Payment</th>
                                <th class="px-3 md:px-4 py-2 md:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden sm:table-cell">Balance</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white">
                            <?php
                                $balance = $loan->total_amount;
                                $monthlyPayment = $loan->monthly_payment;
                            ?>
                            <?php for($month = 1; $month <= min($loan->term_months, 6); $month++): ?>
                            <tr class="border-b border-gray-100">
                                <td class="px-3 md:px-4 py-2 md:py-3">
                                    <span class="text-sm font-medium text-gray-900"><?php echo e($month); ?></span>
                                </td>
                                <td class="px-3 md:px-4 py-2 md:py-3">
                                    <span class="text-sm font-medium text-gray-900"><?php echo e(number_format($monthlyPayment, 0)); ?></span>
                                </td>
                                <td class="px-3 md:px-4 py-2 md:py-3 hidden sm:table-cell">
                                    <?php
                                        $balance -= $monthlyPayment;
                                        if($balance < 0) $balance = 0;
                                    ?>
                                    <span class="text-sm font-medium text-gray-900"><?php echo e(number_format($balance, 0)); ?></span>
                                </td>
                            </tr>
                            <?php endfor; ?>
                            <?php if($loan->term_months > 6): ?>
                            <tr class="bg-gray-50">
                                <td colspan="3" class="px-3 md:px-4 py-2 md:py-3 text-center">
                                    <span class="text-xs md:text-sm text-gray-600">
                                        and <?php echo e($loan->term_months - 6); ?> more months
                                    </span>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-4">
            <!-- Quick Actions -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4">
                <h3 class="text-base font-semibold text-gray-900 mb-3 flex items-center">
                    <i class="fas fa-bolt mr-2 text-yellow-600"></i>
                    Quick Actions
                </h3>
                <div class="space-y-2">
                    <?php if($loan->status === 'pending'): ?>
                    <a href="<?php echo e(route('member.loans.edit', $loan)); ?>" class="w-full inline-flex items-center justify-center px-3 py-2 text-sm font-medium rounded-md text-white bg-yellow-600 hover:bg-yellow-700 transition-colors">
                        <i class="fas fa-edit mr-2"></i><span class="hidden sm:inline">Edit Application</span><span class="sm:hidden">Edit</span>
                    </a>
                    <button onclick="deleteLoan(<?php echo e($loan->id); ?>)" class="w-full inline-flex items-center justify-center px-3 py-2 text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors">
                        <i class="fas fa-trash mr-2"></i><span class="hidden sm:inline">Delete Application</span><span class="sm:hidden">Delete</span>
                    </button>
                    <?php elseif($loan->status === 'approved' || $loan->status === 'active'): ?>
                    <button onclick="payLoan(<?php echo e($loan->id); ?>)" class="w-full inline-flex items-center justify-center px-3 py-2 text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700 transition-colors" data-toggle="modal" data-target="#paymentModal">
                        <i class="fas fa-credit-card mr-2"></i><span class="hidden sm:inline">Make Payment</span><span class="sm:hidden">Pay</span>
                    </button>
                    <?php endif; ?>

                    <a href="<?php echo e(route('member.loans.index')); ?>" class="w-full inline-flex items-center justify-center px-3 py-2 text-sm font-medium rounded-md text-gray-700 bg-white border border-gray-300 hover:bg-gray-50 transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i><span class="hidden sm:inline">Back to Loans</span><span class="sm:hidden">Back</span>
                    </a>
                </div>

            </div>

            <!-- Application Timeline -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4">
                <h3 class="text-base font-semibold text-gray-900 mb-3 flex items-center">
                    <i class="fas fa-history mr-2 text-green-600"></i>
                    Application Timeline
                </h3>
                <div class="space-y-3">
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-paper-plane text-green-600 text-sm"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 mb-1">Application Submitted</p>
                            <p class="text-xs text-gray-500 mb-1"><?php echo e($loan->created_at->format('M d, Y \a\t H:i')); ?></p>
                            <p class="text-xs text-gray-600">Your loan application has been received and is being processed.</p>
                        </div>
                    </div>

                    <?php if($loan->approved_at): ?>
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-check text-green-600 text-sm"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 mb-1">Application Approved</p>
                            <p class="text-xs text-gray-500 mb-1"><?php echo e($loan->approved_at->format('M d, Y \a\t H:i')); ?></p>
                            <p class="text-xs text-gray-600">Congratulations! Your loan application has been approved.</p>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if($loan->status === 'active'): ?>
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-play text-green-600 text-sm"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 mb-1">Loan Active</p>
                            <p class="text-xs text-gray-500 mb-1">Currently active</p>
                            <p class="text-xs text-gray-600">Your loan is now active and repayments have begun.</p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Support -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4">
                <h3 class="text-base font-semibold text-gray-900 mb-3 flex items-center">
                    <i class="fas fa-headset mr-2 text-green-600"></i>
                    Need Help?
                </h3>
                <div class="space-y-3">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-phone text-green-600 text-sm"></i>
                        <div>
                            <p class="text-sm font-medium text-gray-900">+254 700 000 000</p>
                            <p class="text-xs text-gray-500">Call us</p>
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-envelope text-green-600 text-sm"></i>
                        <div>
                            <p class="text-sm font-medium text-gray-900">loans@morio-sacco.co.ke</p>
                            <p class="text-xs text-gray-500">Email us</p>
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-clock text-green-600 text-sm"></i>
                        <div>
                            <p class="text-sm font-medium text-gray-900">Mon-Fri: 8AM-5PM</p>
                            <p class="text-xs text-gray-500">Business hours</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="paymentModalLabel">
                    <i class="fas fa-credit-card mr-2"></i>Make Loan Payment
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="paymentForm" onsubmit="submitPayment(event)">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="payment_amount" class="form-label">Payment Amount (KSh)</label>
                        <input type="number" id="payment_amount" name="amount" min="1" step="0.01"
                                class="form-control" placeholder="Enter payment amount" required>
                        <small class="form-text text-muted">Monthly payment: KSh <?php echo e(number_format($loan->monthly_payment, 2)); ?></small>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i>Cancel
                    </button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane mr-1"></i>Send M-Pesa Request
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
function deleteLoan(loanId) {
    Swal.fire({
        title: 'Are you sure?',
        text: 'This will permanently delete your loan application. This action cannot be undone.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Deleting...',
                text: 'Please wait while we delete your application.',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });

            // Create form for DELETE request
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `<?php echo e(url('member/loans')); ?>/${loanId}`;
            form.style.display = 'none';

            // Add method spoofing for DELETE
            const methodInput = document.createElement('input');
            methodInput.type = 'hidden';
            methodInput.name = '_method';
            methodInput.value = 'DELETE';
            form.appendChild(methodInput);

            // Add CSRF token
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfToken);

            // Add to body and submit
            document.body.appendChild(form);
            form.submit();
        }
    });
}

function payLoan(loanId) {
    $('#payment_amount').val(''); // Clear previous value
    $('#paymentModal').modal('show');
}

function submitPayment(event) {
    event.preventDefault();

    const formData = new FormData(event.target);

    $.ajax({
        url: `<?php echo e(url('member/loans')); ?>/$<?php echo e($loan->id); ?>/pay`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(data) {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Payment Initiated!',
                    text: 'Please check your phone and complete the M-Pesa payment.',
                    timer: 3000,
                    showConfirmButton: false
                });
                $('#paymentModal').modal('hide');
                $('#paymentForm')[0].reset();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Payment Failed',
                    text: data.message
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred while processing your payment.'
            });
        }
    });
}

// Reset form when modal is hidden
$('#paymentModal').on('hidden.bs.modal', function() {
    $('#paymentForm')[0].reset();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views/member/loans/show.blade.php ENDPATH**/ ?>